/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.items;

import com.mlib.Random;
import com.mlib.data.SerializableHelper;
import com.mlib.data.SerializableList;
import com.mlib.data.SerializableStructure;
import com.mlib.entities.EntityHelper;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ToolActions;
import org.jetbrains.annotations.Nullable;

public class ItemHelper {
    private static final double MINECRAFT_WEAPON_ENCHANT_CHANCE = 0.25;
    private static final double MINECRAFT_ARMOR_PIECE_ENCHANT_CHANCE = 0.5;

    public static int getEnchantmentLevel(double clampedRegionalDifficulty) {
        return (int)(5.0 + 18.0 * clampedRegionalDifficulty);
    }

    public static ItemStack damageItem(ItemStack itemStack, double factor) {
        if ((double)itemStack.m_41776_() * factor < 1.0) {
            return ItemStack.f_41583_;
        }
        itemStack.m_41721_(Random.nextInt((int)((double)itemStack.m_41776_() * factor)));
        return itemStack;
    }

    public static ItemStack enchantItem(ItemStack itemStack, double clampedRegionalDifficulty, boolean isTreasureAllowed) {
        return EnchantmentHelper.m_220292_((RandomSource)Random.getThreadSafe(), (ItemStack)itemStack, (int)ItemHelper.getEnchantmentLevel(clampedRegionalDifficulty), (boolean)isTreasureAllowed);
    }

    public static ItemStack tryEnchantItem(ItemStack itemStack, double clampedRegionalDifficulty, boolean isTreasureAllowed, double chance) {
        return Random.tryChance(chance) ? ItemHelper.enchantItem(itemStack, clampedRegionalDifficulty, isTreasureAllowed) : itemStack;
    }

    public static ItemStack tryEnchantWeapon(ItemStack weaponItemStack, double clampedRegionalDifficulty, boolean isTreasureAllowed) {
        return ItemHelper.tryEnchantItem(weaponItemStack, clampedRegionalDifficulty, isTreasureAllowed, 0.25);
    }

    public static ItemStack tryEnchantArmor(ItemStack armorItemStack, double clampedRegionalDifficulty, boolean isTreasureAllowed) {
        return ItemHelper.tryEnchantItem(armorItemStack, clampedRegionalDifficulty, isTreasureAllowed, 0.5);
    }

    public static ItemStack damageAndEnchantItem(ItemStack itemStack, double clampedRegionalDifficulty, boolean isTreasureAllowed, double damageFactor) {
        return ItemHelper.damageItem(ItemHelper.enchantItem(itemStack, clampedRegionalDifficulty, isTreasureAllowed), damageFactor);
    }

    public static void giveItemStackToPlayer(ItemStack itemStack, Player player, ServerLevel level) {
        if (!player.m_150109_().m_36054_(itemStack)) {
            double x = player.m_20185_();
            double y = player.m_20186_() + 1.0;
            double z = player.m_20189_();
            level.m_7967_((Entity)new ItemEntity((Level)level, x, y, z, itemStack));
        }
    }

    @Nullable
    public static EquipmentSlot equip(Mob mob, ItemStack itemStack) {
        if (!mob.m_7252_(itemStack)) {
            return null;
        }
        EquipmentSlot equipmentSlot = Mob.m_147233_((ItemStack)itemStack);
        equipmentSlot = equipmentSlot.m_20743_() == EquipmentSlot.Type.ARMOR ? equipmentSlot : EquipmentSlot.MAINHAND;
        mob.m_8061_(equipmentSlot, itemStack);
        return equipmentSlot;
    }

    public static void consumeItemOnUse(ItemStack itemStack, Player player) {
        player.m_36246_(Stats.f_12982_.m_12902_((Object)itemStack.m_41720_()));
        if (!EntityHelper.isOnCreativeMode(player)) {
            itemStack.m_41774_(1);
        }
    }

    @SafeVarargs
    public static boolean has(@Nullable LivingEntity entity, EquipmentSlot equipmentSlot, Class<? extends Item> ... itemClasses) {
        Item item = entity != null ? entity.m_6844_(equipmentSlot).m_41720_() : null;
        for (Class<? extends Item> itemClass : itemClasses) {
            if (!itemClass.isInstance(item)) continue;
            return true;
        }
        return false;
    }

    @SafeVarargs
    public static boolean hasInMainHand(@Nullable LivingEntity entity, Class<? extends Item> ... itemClasses) {
        return ItemHelper.has(entity, EquipmentSlot.MAINHAND, itemClasses);
    }

    public static ItemStack getCurrentlyUsedItem(LivingEntity entity) {
        return entity.m_6117_() ? entity.m_21120_(entity.m_7655_()) : ItemStack.f_41583_;
    }

    public static ItemStack getMatchingHandItem(LivingEntity entity, Predicate<ItemStack> predicate) {
        return predicate.test(entity.m_21205_()) ? entity.m_21205_() : entity.m_21206_();
    }

    public static void addCooldown(Player player, int duration, Item ... items) {
        ItemCooldowns cooldowns = player.m_36335_();
        for (Item item : items) {
            cooldowns.m_41524_(item, duration);
        }
    }

    public static boolean isOnCooldown(Player player, Item ... items) {
        ItemCooldowns cooldowns = player.m_36335_();
        for (Item item : items) {
            if (!cooldowns.m_41519_(item)) continue;
            return true;
        }
        return false;
    }

    public static boolean isShield(Item item) {
        return item.canPerformAction(ItemStack.f_41583_, ToolActions.SHIELD_BLOCK);
    }

    public static boolean isRangedWeapon(Item item) {
        return item instanceof BowItem || item instanceof CrossbowItem;
    }

    public static boolean isMeleeWeapon(Item item) {
        return item instanceof SwordItem || item instanceof TridentItem || item instanceof AxeItem;
    }

    public static boolean isGoldenTool(Item item) {
        DiggerItem diggerItem;
        SwordItem swordItem;
        return item instanceof SwordItem && (swordItem = (SwordItem)item).m_43314_() == Tiers.GOLD || item instanceof DiggerItem && (diggerItem = (DiggerItem)item).m_43314_() == Tiers.GOLD;
    }

    public static boolean isGoldenArmor(Item item) {
        ArmorItem armorItem;
        return item instanceof ArmorItem && (armorItem = (ArmorItem)item).m_40401_() == ArmorMaterials.GOLD;
    }

    public static boolean isAnyTool(Item item) {
        return item instanceof SwordItem || item instanceof TridentItem || item instanceof DiggerItem || item instanceof BowItem || item instanceof CrossbowItem;
    }

    public static boolean isFishingRod(ItemStack itemStack) {
        return itemStack.m_41720_().canPerformAction(itemStack, ToolActions.FISHING_ROD_CAST);
    }

    public static void addEnchantmentTypeToItemGroup(CreativeModeTab itemTab, EnchantmentCategory category) {
        EnchantmentCategory[] group = itemTab.m_40795_();
        if (group.length == 0) {
            itemTab.m_40781_(new EnchantmentCategory[]{category});
            return;
        }
        EnchantmentCategory[] temporary = new EnchantmentCategory[group.length + 1];
        System.arraycopy(group, 0, temporary, 0, group.length);
        temporary[group.length - 1] = category;
        itemTab.m_40781_(temporary);
    }

    public static void addEnchantmentTypesToItemGroup(CreativeModeTab itemTab, EnchantmentCategory ... categories) {
        EnchantmentCategory[] group = itemTab.m_40795_();
        if (group.length == 0) {
            itemTab.m_40781_(categories);
        } else {
            EnchantmentCategory[] temporary = new EnchantmentCategory[group.length + categories.length];
            System.arraycopy(group, 0, temporary, 0, group.length);
            int i = 1;
            EnchantmentCategory[] enchantmentCategoryArray = categories;
            int n = enchantmentCategoryArray.length;
            for (int j = 0; j < n; ++j) {
                EnchantmentCategory category;
                temporary[group.length - i] = category = enchantmentCategoryArray[j];
                ++i;
            }
            itemTab.m_40781_(temporary);
        }
    }

    public static EnchantmentsInfo getEnchantmentsInfo(ItemStack itemStack) {
        return SerializableHelper.read(EnchantmentsInfo::new, (Tag)itemStack.m_41785_());
    }

    public static class EnchantmentsInfo
    extends SerializableList {
        public List<EnchantmentInfo> enchantments;

        public EnchantmentsInfo() {
            this.defineCustom(() -> this.enchantments, x -> {
                this.enchantments = x;
            }, EnchantmentInfo::new);
        }
    }

    public static class EnchantmentInfo
    extends SerializableStructure {
        public String id;
        public int level;

        public EnchantmentInfo() {
            this.defineString("id", () -> this.id, x -> {
                this.id = x;
            });
            this.defineInteger("lvl", () -> this.level, x -> {
                this.level = x;
            });
        }
    }
}

